#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_BloodUnitReport : BaseTest 
	{

		BOL.BloodUnitReport _tstBUR;
		
		private DataTable _dtBloodUnit;
		System.Guid _unitGuid;

		[SetUp]
		protected void SetUp() 
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{

				this._dtBloodUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);
				this._unitGuid = (System.Guid)this._dtBloodUnit.Rows[0][TABLES.BloodUnit.BloodUnitGuid];

				this.RefreshData = false;
			}
			
			this._tstBUR = new BOL.BloodUnitReport(this._unitGuid);
		}
			
		[Test]
		public void Ctor_Empty_Pass()
		{
			BOL.BloodUnitReport tmpBUR = new BOL.BloodUnitReport();
			
			Assert.IsTrue(tmpBUR.BloodUnitGuid==Guid.Empty);

			Assert.IsTrue(tmpBUR.EyeReadableUnitId==String.Empty);
			Assert.IsTrue(tmpBUR.ProductCode==String.Empty);

			Assert.IsTrue(tmpBUR.IncludeIncomingShipmentReport==false);
			Assert.IsTrue(tmpBUR.IncludeOutgoingShipmentReport==false);
			Assert.IsTrue(tmpBUR.IncludeAntigenTypingReport==false);
			Assert.IsTrue(tmpBUR.IncludeRestrictedPatientReport==false);
			Assert.IsTrue(tmpBUR.IncludeStatusReport==false);
			Assert.IsTrue(tmpBUR.IncludeFinanceReport==false);
			Assert.IsTrue(tmpBUR.IncludePatientAssociationReport==false);
			Assert.IsTrue(tmpBUR.IncludeIssueReport==false);
			Assert.IsTrue(tmpBUR.IncludeBloodUnitTestingReport==false);
			Assert.IsTrue(tmpBUR.IncludeCrossmatchTestingReport==false);
			Assert.IsTrue(tmpBUR.IncludeModificationReport==false);
			Assert.IsTrue(tmpBUR.IncludeTransfusionReport==false);
			Assert.IsTrue(tmpBUR.IncludeExceptionReport==false);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Empty_Fail()
		{
		}

		[Test]
		public void Ctor_Guid_Pass()
		{
			BOL.BloodUnitReport tmpBUR = new BOL.BloodUnitReport(this._unitGuid);
			
			Assert.IsNotNull(tmpBUR);
			Assert.AreEqual(tmpBUR.BloodUnitGuid, this._unitGuid);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Guid_Fail()
		{
		}


		[Test]
		public void GetBloodUnitsForHistoryReport_Pass()
		{
			DataTable dt = BOL.BloodUnitReport.GetBloodUnitsForHistoryReport();
			Assert.IsTrue(dt.Rows.Count > 0);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetBloodUnitsForHistoryReport_Fail()
		{
		}

		
		[Test]
		public void GetReportBloodUnitHistoryRecordCount_Pass()
		{
			DataTable dt = BOL.BloodUnitReport.GetBloodUnitsForHistoryReport();
			Guid bloodUnitGuid = new Guid(dt.Rows[0][TABLES.BloodUnit.BloodUnitGuid].ToString());

			int tstValue = BOL.BloodUnitReport.GetReportBloodUnitHistoryRecordCount(bloodUnitGuid, true, true, true, true,true,true, true, true, true,true,true, true,true);

			Assert.IsTrue(tstValue > 0);
		}

		[Test]
		public void GetReportBloodUnitHistoryRecordCount_Fail()
		{
			int tstValue = BOL.BloodUnitReport.GetReportBloodUnitHistoryRecordCount(System.Guid.NewGuid(), true, true, true, true,true,true, true, true, true,true,true, true,true);

			Assert.AreEqual(0,tstValue);
		}


		[Test]
		public void GetReportTables_Pass()
		{

				DataTable dt = BOL.BloodUnitReport.GetBloodUnitsForHistoryReport();

				Guid bloodUnitGuid = new Guid(dt.Rows[0][TABLES.BloodUnit.BloodUnitGuid].ToString());
			try
			{
				BOL.BloodUnitReport bloodUnitReport = new BOL.BloodUnitReport(bloodUnitGuid);

				bloodUnitReport.IncludeAntigenTypingReport = true;
				bloodUnitReport.IncludeBloodUnitTestingReport = true;
				bloodUnitReport.IncludeCrossmatchTestingReport = true;
				bloodUnitReport.IncludeRestrictedPatientReport = true;
				bloodUnitReport.IncludeExceptionReport = true;
				bloodUnitReport.IncludeFinanceReport = true;
				bloodUnitReport.IncludeIncomingShipmentReport = true;
				bloodUnitReport.IncludeIssueReport = true;
				bloodUnitReport.IncludeModificationReport = true;
				bloodUnitReport.IncludeOutgoingShipmentReport = true;
				bloodUnitReport.IncludePatientAssociationReport = true;
				bloodUnitReport.IncludeStatusReport = true;
				bloodUnitReport.IncludeTransfusionReport = true;

				bloodUnitReport.StartDate = System.DateTime.Now.AddYears(-1);
				bloodUnitReport.EndDate = System.DateTime.Now.AddYears(1);

				DataSet reportData = bloodUnitReport.GetReportTables();
				Assert.IsTrue(reportData.Tables.Count > 0);
			}
			catch(Exception err)
			{
				Assert.IsTrue(false, bloodUnitGuid.ToString() + "-" + err.Message);
			}
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetReportTables_Fail()
		{
		}

		
		[Test]
		public void GetReportCriteria_Pass()
		{
			DataTable dt = BOL.BloodUnitReport.GetBloodUnitsForHistoryReport();

			Guid bloodUnitGuid = new Guid(dt.Rows[0][TABLES.BloodUnit.BloodUnitGuid].ToString());
			
			BOL.BloodUnitReport bloodUnitReport = new BOL.BloodUnitReport(bloodUnitGuid);

			bloodUnitReport.IncludeAntigenTypingReport = true;
			bloodUnitReport.IncludeBloodUnitTestingReport = true;
			bloodUnitReport.IncludeCrossmatchTestingReport = true;
			bloodUnitReport.IncludeRestrictedPatientReport = true;
			bloodUnitReport.IncludeExceptionReport = true;
			bloodUnitReport.IncludeFinanceReport = true;
			bloodUnitReport.IncludeIncomingShipmentReport = true;
			bloodUnitReport.IncludeIssueReport = true;
			bloodUnitReport.IncludeModificationReport = true;
			bloodUnitReport.IncludeOutgoingShipmentReport = true;
			bloodUnitReport.IncludePatientAssociationReport = true;
			bloodUnitReport.IncludeStatusReport = true;
			bloodUnitReport.IncludeTransfusionReport = true;

			bloodUnitReport.StartDate = System.DateTime.Now.AddYears(-1);
			bloodUnitReport.EndDate = System.DateTime.Now.AddYears(1);

			DataSet reportData = bloodUnitReport.GetReportTables();
				
			string tstValue = bloodUnitReport.GetReportCriteria();

			Assert.IsNotNull(tstValue);
		}

		
		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetReportCriteria_Fail()
		{
		}

		[Test]
		public void BloodUnitGuid_Pass()
		{
			System.Guid testguid=System.Guid.NewGuid();

			_tstBUR.BloodUnitGuid=testguid;

			Assert.IsTrue(_tstBUR.BloodUnitGuid==testguid);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void BloodUnitGuid_Fail()
		{
		}

		[Test]
		public void EyeReadableUnitId_Pass()
		{
			string testid="11111";

			_tstBUR.EyeReadableUnitId=testid;

			Assert.IsTrue(_tstBUR.EyeReadableUnitId==testid);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void EyeReadableUnitId_Fail()
		{
		}

		[Test]
		public void ProductCode_Pass()
		{
			string testid="11111";

			_tstBUR.ProductCode=testid;

			Assert.IsTrue(_tstBUR.ProductCode==testid);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void ProductCode_Fail()
		{
		}

		[Test]
		public void ReportsSelected_Pass()
		{
			_tstBUR.IncludeAntigenTypingReport = false;
			_tstBUR.IncludeBloodUnitTestingReport = false;
			_tstBUR.IncludeCrossmatchTestingReport = false;
			_tstBUR.IncludeRestrictedPatientReport = false;
			_tstBUR.IncludeExceptionReport = false;
			_tstBUR.IncludeFinanceReport = false;
			_tstBUR.IncludeIncomingShipmentReport = false;
			_tstBUR.IncludeIssueReport = false;
			_tstBUR.IncludeModificationReport = false;
			_tstBUR.IncludeOutgoingShipmentReport = false;
			_tstBUR.IncludePatientAssociationReport = false;
			_tstBUR.IncludeStatusReport = false;
			_tstBUR.IncludeTransfusionReport = false;
			_tstBUR.IncludeAntigenTypingReport=true;
			_tstBUR.IncludeBloodUnitTestingReport=true;

			Assert.IsTrue(_tstBUR.ReportsSelected>=2);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void ReportsSelected_Fail()
		{
		}

		[Test]
		public void IncludeIncomingShipmentReport_Pass()
		{
			bool test=true;

			_tstBUR.IncludeIncomingShipmentReport=test;

			Assert.IsTrue(_tstBUR.IncludeIncomingShipmentReport==test);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeIncomingShipmentReport_Fail()
		{
		}

		[Test]
		public void IncludeOutgoingShipmentReport_Pass()
		{
			bool test=true;

			_tstBUR.IncludeOutgoingShipmentReport=test;

			Assert.IsTrue(_tstBUR.IncludeOutgoingShipmentReport==test);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeOutgoingShipmentReport_Fail()
		{
		}

		[Test]
		public void IncludeAntigenTypingReport_Pass()
		{
			bool test=true;

			_tstBUR.IncludeAntigenTypingReport=test;

			Assert.IsTrue(_tstBUR.IncludeAntigenTypingReport==test);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeAntigenTypingReport_Fail()
		{
		}

		[Test]
		public void IncludeRestrictedPatientReport_Pass()
		{
			bool test=true;

			_tstBUR.IncludeRestrictedPatientReport=test;

			Assert.IsTrue(_tstBUR.IncludeRestrictedPatientReport==test);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeRestrictedPatientReport_Fail()
		{
		}

		[Test]
		public void IncludeStatusReport_Pass()
		{
			bool test=true;

			_tstBUR.IncludeStatusReport=test;

			Assert.IsTrue(_tstBUR.IncludeStatusReport==test);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeStatusReport_Fail()
		{
		}

		[Test]
		public void IncludeFinanceReport_Pass()
		{
			bool test=true;

			_tstBUR.IncludeFinanceReport=test;

			Assert.IsTrue(_tstBUR.IncludeFinanceReport==test);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeFinanceReport_Fail()
		{
		}

		[Test]
		public void IncludePatientAssociationReport_Pass()
		{
			bool test=true;

			_tstBUR.IncludePatientAssociationReport=test;

			Assert.IsTrue(_tstBUR.IncludePatientAssociationReport==test);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludePatientAssociationReport_Fail()
		{
		}

		[Test]
		public void IncludeIssueReport_Pass()
		{
			bool test=true;

			_tstBUR.IncludeIssueReport=test;

			Assert.IsTrue(_tstBUR.IncludeIssueReport==test);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeIssueReport_Fail()
		{
		}

		[Test]
		public void IncludeBloodUnitTestingReport_Pass()
		{
			bool test=true;

			_tstBUR.IncludeBloodUnitTestingReport=test;

			Assert.IsTrue(_tstBUR.IncludeBloodUnitTestingReport==test);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeBloodUnitTestingReport_Fail()
		{
		}

		[Test]
		public void IncludeCrossmatchTestingReport_Pass()
		{
			bool test=true;

			_tstBUR.IncludeCrossmatchTestingReport=test;

			Assert.IsTrue(_tstBUR.IncludeCrossmatchTestingReport==test);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeCrossmatchTestingReport_Fail()
		{
		}

		[Test]
		public void IncludeModificationReport_Pass()
		{
			bool test=true;

			_tstBUR.IncludeModificationReport=test;

			Assert.IsTrue(_tstBUR.IncludeModificationReport==test);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeModificationReport_Fail()
		{
		}

		[Test]
		public void IncludeTransfusionReport_Pass()
		{
			bool test=true;

			_tstBUR.IncludeTransfusionReport=test;

			Assert.IsTrue(_tstBUR.IncludeTransfusionReport==test);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeTransfusionReport_Fail()
		{
		}

		[Test]
		public void IncludeExceptionReport_Pass()
		{
			bool test=true;

			_tstBUR.IncludeExceptionReport=test;

			Assert.IsTrue(_tstBUR.IncludeExceptionReport==test);
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void IncludeExceptionReport_Fail()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass()
		{
			//Sends report to printer
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail()
		{
			//Sends report to printer
		}
	}
}

#endif
